/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

float curl = 20.0;


// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
float T = 1.;
float hash( float n )
{
    return fract(sin(n)*43758.5453);
}

float noise( in vec2 x )
{
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f*f*(3.0-2.0*f);
    float n = p.x + p.y*57.0;
    return mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
               mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y);
}

vec2 map( vec2 p, in float offset )
{

    float a = 0.;
    float b = 1.57;
       
   	float alpha = (-p.y + 1.0) * 0.5;
   	a = 3.14159*(0.5 + sin(p.y*curl)*0.167 + sin(iGlobalTime)*0.55*min(alpha,0.5));
    a = mix(b,a,alpha);
   
	return vec2( cos(a), sin(a) );
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = fragCoord.xy/1. / iResolution.xy;
    
    p.x += sin(iGlobalTime-1.2)*0.05;
    
	vec2 uv = -1.0 + 2.0*p;
	uv.x *= iResolution.x / iResolution.y;
		
    float offset = T+fragCoord.x/iResolution.x;
    
	float acc = 0.0;
	vec3  col = vec3(0.0);

    float ycut = sin(iGlobalTime);
    vec2 uv2 = uv;
    
    vec2 dir;
    
	for( int i=0; i<32; i++ )
	{
		dir = map( uv, offset );
		
		float h = float(i)/32.0;
		float w = 4.0*h*(1.0-h);
		
		vec3 ttt = w*texture2D( iChannel0, uv * vec2(1,1.0) ).xyz;
		ttt *= mix( vec3(0.6,0.7,0.7), vec3(1.0,0.95,0.9), 0.5 - 0.5*dot( reflect(vec3(dir,0.0), vec3(1.0,0.0,0.0)).xy, vec2(0.707) ) );
		col += w*ttt;
		acc += w;
        col *= smoothstep(1.0, 0.0, (-clamp(uv.y,-1.0,-0.8) - 0.8) * 5.0);

        uv2 = uv;
        uv2.y -= ycut * (uv.x) *0.1;
        uv2.y -= abs(uv.x)*0.1;
        
        if (uv2.x < -0.5 || uv2.x > 0.5 || uv2.y < -0.44)
        {
            float f = 	hash(floor(uv.x*64.));
            f +=	 	hash(floor(uv.x*64.) + 1.);
            f +=	 	hash(floor(uv.x*64.) - 1.);
            f += 		hash(floor(uv.x*64.) + 2.)*0.5;
            f += 		hash(floor(uv.x*64.) - 2.)*0.5;

            if (uv2.y < -0.7)
            {
                acc += smoothstep(0., f*0.25, -(uv2.y - -0.7) / 0.3)*10.0 ;
            }

            if (abs(uv.x) > 0.5)
            {
                acc += smoothstep(0., 1.0, 2.0*clamp(abs(uv.x) - 0.5, 0., 0.4)/0.6) * 10.0;
            }
    	}
		uv += 0.008*dir;
    }
    
    uv -= 0.008*dir;

    uv.y -= ycut * (uv.x) *0.5;

    if (abs(uv.x) > 0.5)
    {
        acc += smoothstep(0., 1.0, 2.0*clamp(abs(uv.x) - 0.5, 0., 0.5)/0.5) * 1000.0;
    }

    if (uv2.y < -0.50)
    {
        float f = 	hash(floor(uv.x*64.));
        f += 		hash(floor(uv.x*64.) + 1.);
        f += 		hash(floor(uv.x*64.) - 1.);
        f += 		hash(floor(uv.x*64.) + 2.)*0.5;
        f += 		hash(floor(uv.x*64.) - 2.)*0.5;
        acc += smoothstep(0., pow(clamp(f*0.25,0.0,1.0), 0.5), -(uv2.y - -0.50) / 1.0)*1000.0 ;
    }    
    col /= acc;
    
	float gg = dot( col, vec3(0.333) );
	vec3 nor = normalize( vec3( dFdx(gg), 0.5, dFdy(gg) ) );
	col += vec3(0.4)*dot( nor, vec3(0.7,0.01,0.7) );

	vec2 di = map( uv, offset );
	col *= 0.65 + 0.35*dot( di, vec2(0.707) );
	col *= 0.20 + 0.80*pow( 4.0*p.x*(1.0-p.x), 0.1 );
	col *= 1.7;

	fragColor = vec4( col, length(col)*1.5 );
    
}

void main ( void )
 { mainImage( gl_FragColor, gl_FragCoord.xy );
 }